<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Stock_Counter_Model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }
    
    //product full_stock_balance start--------------------------------------------------------------------------------
    function get_stock_balance($warehouse_id='',$product_id){
        $grn_total= $this->get_grn_qty($warehouse_id,$product_id);
        $sale_total= $this->get_sale_qty($warehouse_id,$product_id);
        $sale_return_total= $this->get_sale_return_qty($warehouse_id,$product_id);
        $damage_total= $this->get_damage_qty($warehouse_id,$product_id);
        $grn_return_total= $this->get_grn_return_qty($warehouse_id,$product_id);
        $transfer_stock= $this->get_transfer_stock($warehouse_id,$product_id);
        $product_balance=(($grn_total-$grn_return_total-$transfer_stock)-$damage_total)-($sale_total-$sale_return_total);
        $temp_balance= round($product_balance,3);
        if($temp_balance==(-0)){
            return 0;
        }else{
            return $temp_balance;
        }
    }
    function get_grn_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('purchase_items p');
        $this->db->where('p.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_sale_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('hw_sale_items p');
        $this->db->where('p.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_sale_return_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('hw_sales_return_items p');
        $this->db->where('p.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
            
        }
    }
    function get_damage_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('p.pdmgitm_quantity');
        $this->db->from('product_damage_item p');
        $this->db->where('p.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['pdmgitm_quantity']))
        {
            return $result['pdmgitm_quantity'];
        }else{
       return 0;
        }
    }
     function get_grn_return_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('purchase_return_items p');
        $this->db->where('p.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    
    function get_transfer_stock($warehouse_id='',$product_id){
        $this->db->select_sum('p.quantity');
        $this->db->from('stock_transfer_item p');
        $this->db->where('p.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    
    
    //product full_stock_balance end----------------------------------------------------------------------------------------------
    
    
    //batch_stock balance start------------------------------------------------------------------------------------------------------
      function get_stock_balance_batch($warehouse_id='',$product_id,$batch_id){
          
         
        $grn_total= $this->get_batch_grn_qty($warehouse_id,$product_id,$batch_id);
        $sale_total= $this->get_batch_sale_qty($warehouse_id,$product_id,$batch_id);
        $sale_return_total= $this->get_batch_sale_return_qty($warehouse_id,$product_id,$batch_id);
        $adjesment_total= $this->get_batch_adjesment_qty($warehouse_id,$product_id,$batch_id);
        $grn_return_total= $this->get_batch_grn_return_qty($warehouse_id,$product_id,$batch_id);
        $transfer_stock=$this->get_transfer_stock_batch($warehouse_id,$product_id,$batch_id);
        $damage_stock=$this->get_batch_damage_qty($warehouse_id,$product_id,$batch_id);
        
        
        
        $product_balance=($grn_total-$grn_return_total-$transfer_stock-$damage_stock)-($sale_total-$sale_return_total)+$adjesment_total;
        $temp_balance= round($product_balance,3);
        if($temp_balance==(-0)){
            return 0;
        }else{
            return $temp_balance;
        }
    }
    function get_batch_grn_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('bg.quantity');
        $this->db->from('btatch_prroduct_grn bg');
        $this->db->where('bg.batch_id', $batch_id);
       // $this->db->join('purchase_items p','p.id=grn_item_id','inner');
        //$this->db->where('p.product_id', $product_id);
        //$this->db->group_by('p.product_id');
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_batch_sale_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('hw_sale_items p');
        //$this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    
     function get_batch_sale_return_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('hw_sales_return_items p');
       // $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    
     function get_batch_adjesment_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.batch_qty');
        $this->db->from('batch_stock_adjesment p');
        //$this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['batch_qty']))
        {
            return $result['batch_qty'];
        }else{
       return 0;
        }
    }
     function get_batch_grn_return_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('purchase_return_items p');
        //$this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    
    function get_transfer_stock_batch($warehouse_id='',$product_id,$batch_id){
        $this->db->select_sum('p.quantity');
        $this->db->from('stock_transfer_item p');
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    
    
     function get_batch_damage_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.pdmgitm_quantity');
        $this->db->from('product_damage_item p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['pdmgitm_quantity']))
        {
            return $result['pdmgitm_quantity'];
        }else{
       return 0;
        }
    }
     //product batch_stock balance end-------------------------------------------------------------------------------
     
     //product batch purcheses balance stsrt ------------------------------------------------------------------------
     
     function get_purchased_stock_balance($product_id,$grn_id){
        $grn_total= $this->get_purchased_grn_qty($product_id,$grn_id);
        $grn_return_total= $this->get_purchased_return_grn_qty_total($product_id,$grn_id);
        $product_balance=$grn_total-$grn_return_total;
        return $product_balance;
    }
     function get_purchased_grn_qty($product_id,$grn_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('purchase_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.id', $grn_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_purchased_return_grn_qty_total($product_id,$grn_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('purchase_return_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.grn_item_id', $grn_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
     //product batch purcheses balance end ------------------------------------------------------------------------
     
     function get_stock_ledger_balance($warehouse_id='',$product_id,$batch_id=''){
         
        $this->db->select_sum('p.quantity');
        $this->db->from('stock_ledger p');
        if($batch_id){
        $this->db->where('p.batch_id', $batch_id);
        }
         $this->db->where('p.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity']+0;
        }else{
       return 0;
        }
         
     }
   
}