<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Issue_Cards extends CI_Controller {

    var $main_menu_name = "issue_cards";
	var $sub_menu_name = "issue_cards";

	public function __construct()
	{
		parent::__construct();

		$this->load->model('Issue_Cards_Model');
		$this->load->model('Supplier_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		$this->load->model('Tax_Rates_Model');
		$this->load->model('Customer_Model');
		$this->load->model('Sales_Return_Model');
		$this->load->model('User_Model');
		$this->load->model('Transfer_Model');
		$this->load->model('Purchases_Model');
		$this->load->model('Product_Damage_Model');
		$this->load->model('Cash_Collect_Model');
		
	}
	
	//Sales list page load
	public function index()
	{
		 
	//	$data['sales_rep_issues']=$this->Issue_Cards_Model->get_all_sales_rep_issue();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "list_issue";
        $this->load->view('issue_card',$data);
	}	
	
	
	public function manage()
	{	
		$issue_card_id =  $this->uri->segment(3);	
			$route_id=$this->uri->segment(4);		
		if ($issue_card_id==0)
		{
		$data['warehouse_list']=$this->Warehouse_Model->get_all_warehouse();
		$data['routes_list']=$this->Issue_Cards_Model->get_all_routes();
		$data['invoice_list']=$this->Issue_Cards_Model->get_invoice_item_list_by_route_id($route_id);
		$data['route_id']=$route_id;
		$data['cash_collector_list']=$this->User_Model->get_all_cash_collector_users();
		$data['type']='A';
		$data['main_menu_name']=$this->main_menu_name;
		$data['sub_menu_name']='issue_card';
		$this->load->view('issue_card_manage',$data); 		
		}
		else
			{
			$data['route_id']=$route_id;
			$data['routes_list']=$this->Issue_Cards_Model->get_all_routes();		
			$data['cash_collector_list']=$this->User_Model->get_all_cash_collector_users();
			$data['warehouse_list']=$this->Warehouse_Model->get_all_warehouse();
			$data['sales_rep_list']=$this->User_Model->get_all_sales_user_reps();
			$data['type']='E';
			$data['type1']=$issue_card_id;
			$data['main_menu_name']=$this->main_menu_name;
			$data['sub_menu_name']='issue_card';
			$data['invoice_list']=$this->Issue_Cards_Model->get_invoice_item_list_by_route_id($route_id);
			$this->load->view('issue_card_manage',$data); 
			
			}
		
	}
	
	
	/*public function get_all_sales_by_route_id()
	{
	
		$route_id=$this->input->get('RI');
		$route = $this->Issue_Cards_Model->get_all_sales_by_route_id($route_id);
		echo json_encode($route);
		
		
	
		
	}*/
	
	
	
	
	
	public function get_next_ref_no()
	{
	
	$query=$this->Issue_Cards_Model->get_next_ref_no();
	$result=$query->row();
	$issue_card_next_ref_number=sprintf("%05d", $result->issue_card_id+1);
	echo json_encode (array('issue_card_next_ref_number'=>$issue_card_next_ref_number));
		
	}
	
	public function get_sales_suggestion()
	{
		
		$term=$this->input->get('term');
		$data['sales']=$this->Issue_Cards_Model->get_sales_suggestion($term);
		$in_type=$this->input->get('t');
		
		$json=array();
		
		foreach ($data['sales'] as $row)
		{
		 $sale_id=$row['sale_id'];
		 $sale_reference_no=$row['sale_reference_no'];
		 $sale_total=$row['sale_total'];
		 
		 
		 $sendParameters="$sale_id,$sale_reference_no,$sale_total";
		 $invoice_total_amount=" Invoice Total Amount: ".number_format($sale_total, 2, '.', ',');
		
		 $json_itm=array(
			 		'id'=> $row['sale_id'],
					'sale_id'=> $row['sale_id'],
					'sale_reference_no'=> $row['sale_reference_no'],
					'sale_total'=> $row['sale_total'],
					
                    'label'=> "Invoice No ".$row['sale_reference_no']."$invoice_total_amount"
                    );
		
		array_push($json,$json_itm);
						
		}		
		echo json_encode($json);		
		

		
	}
	
	
	
	public function get_all_sales_by_route_id()
	{
		
		$route_id=$this->input->get('RI');
		$data['sales']=$this->Issue_Cards_Model->get_all_sales_by_route_id($route_id);
		
		
		$json=array();
		
		foreach ($data['sales'] as $row)
		{	
			$sale_id=$row['sale_id'];
			
			$slr_count=$this->Issue_Cards_Model->get_return_sales_count_by_sales_id($sale_id);			
			//print_r($slr_count);
			if(isset($slr_count))
			{
				$sale_return_count=$slr_count;
			}
			else
			{
				$sale_return_count=0;
			}
				
				if ($row['sale_pymnt_amount']<$row['sale_total'] && $sale_return_count==0 )
				{
					if(is_null($row['sale_pymnt_amount']))
					{
					$payment=0;	
					}
					else
					{
					$payment=$row['sale_pymnt_amount'];
					}
		 $json_itm=array(
			 		'id'=> $row['sale_id'],
					'sale_id'=> $row['sale_id'],
					'sale_reference_no'=> $row['sale_reference_no'],
					'sale_total'=> $row['sale_total'],
					'sale_pymnt_amount'=>$payment ,
					            
                    );
					//print_r($json_itm);
		
		array_push($json,$json_itm);
						
				}	
		}
		
		echo json_encode($json);		
			
		

		
	}
	
	
	
	
	function save_sales_issue_cards()
	{	
		$query=$this->Issue_Cards_Model->get_next_ref_no();
		$result=$query->row();
		$issue_card_next_ref_number=sprintf("%05d", $result->issue_card_id+1);
		$warehouse_id=$this->input->post('warehouse_id');
		$cash_collector_id=$this->input->post('cash_collector_id');
		$temp_date=$this->input->post('issue_cards_datetime');
		$issue_card_date=date('Y-m-d', strtotime($temp_date));
		$added_date_time =date('Y-m-d H:i:s');
		$last_modified_date_time=date('Y-m-d H:i:s');
		$total_amount=$this->input->post('sale_total');
		$route_id=$this->input->post('route_id');
		$status="";
		$issue_card_id='';
		$error='';
		
		if(!$error)
		{
		$data=array(
		
		
		 	'issue_card_ref_no'=>$issue_card_next_ref_number,
			'wharehouse_id'=>$warehouse_id,
			'collector_id'=>$cash_collector_id,
			'issue_card_date'=>$issue_card_date,
			'added_date_time'=>$added_date_time,
			'total_amount'=>$total_amount,
			'status'=>$status,
			'route_id'=>$route_id,			
			'entered_user_id'=>$this->session->userdata('ss_user_id')
			
			);
			$_insert=$this->Issue_Cards_Model->save_issue_card($data,$issue_card_id);
			$lastid=$this->db->insert_id();
			$issue_card_id=$lastid;
			
			//insert user activity
			$this->Common_Model->add_user_activitie("Added Sales Rep Issue, (Sales Rep Issue No:$issue_card_next_ref_number)");
			$disMsg='Issue Card successfully added';
			
			
			$row=$this->input->post('row');
			$rowCount=$this->input->post('rowCount');
			$data_items =array();
			
			for($i=1; $i<=$rowCount; $i++){
				
				if(isset($row[$i]['sale_id'][0]))
				{					
				$data_item=array(
					
					'issue_card_id'=>$issue_card_id,
					'sale_id'=>$row[$i]['sale_id'][0],
					'invoice_total'=>$row[$i]['sale_total'][0]				
					
				);
				$this->Issue_Cards_Model->save_issue_card_item($data_item);
				$itemid=$this->db->insert_id();
				
				
				}
			}			
			 	
			
			
		}else {
			
			$disMsg='Please select these before adding any product:'.$disMsg;
		}	
		
		$this->session->set_flashdata('message', 'Issue Card successfully added!');
		
		echo json_encode(array('issue_card_id'=>$lastid,'error'=>$error,'disMsg'=>$disMsg,));
		
		
		
		
		
	}
	
	
	
	
	
	
	
	
	
	public function issue_card_details()
	{		
		$issue_card_id =  $this->uri->segment(3);
		$issue_card_details=$this->Issue_Cards_Model->get_issue_card_details_by_issue_card_id($issue_card_id);
		
		
		$collector_id=$issue_card_details['collector_id'];
		$id=$issue_card_details['wharehouse_id'];
		$route_id=$issue_card_details['route_id'];
		
		$data['ICID']=$issue_card_id;
		$data['main_menu_name']=$this->main_menu_name;
		$data['sub_menu_name']='';
		$data['wharehose_details']=$this->Warehouse_Model->get_warehouse_info($id);
		$data['cash_collector_details']=$this->User_Model->get_rep_first_and_second_name_by_id($collector_id);
		$data['issue_card_details']=$this->Issue_Cards_Model->get_issue_card_details_by_issue_card_id($issue_card_id);
		$data['issue_card_items_details']=$this->Issue_Cards_Model-> get_issue_card_item_list_by_issue_card_id($issue_card_id);
		
			
		
		 $this->load->view('issue_card_details',$data);	
	}
	
	
	
	
	
	
	
	
	public function sales_rep_issue_details_print()
	{
		$data['main_menu_name']=$this->main_menu_name;
		$data['sub_menu_name']='';
		$sale_rep_issue_id=$this->input->get('sale_rep_issue_id');
		$rep_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
		$whare_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
		$rep_id=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
		
		$sales_rep_id=$rep_id['sales_rep_id'];
		$id=$whare_id['wharehouse_id'];
		
		$data['SRID']=$sale_rep_issue_id;
		$data['main_menu_name']=$this->main_menu_name;
		$data['sub_menu_name']='';
		$data['wharehose_details']=$this->Warehouse_Model->get_warehouse_info($id);
		$data['sales_rep_details']=$this->User_Model->get_rep_first_and_second_name_by_id($sales_rep_id);
		$data['sales_rep_issue_details']=$this->Sales_Rep_Issue_Model->get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id);
		$data['sales_rep_issue_items_details']=$this->Sales_Rep_Issue_Model-> get_sale_rep_issue_item_list_by_sale_id($sale_rep_issue_id);	
		 
		 $this->load->view('models/sales_rep_issue_details_print',$data);
	}
	
	
	
	public function list_issue_card()
	{	
	
	$data=array();
	
	$issue_card=$this->Issue_Cards_Model->get_all_issue_cards();
	
	foreach ($issue_card as $row)
	{
		$nestedData=array();
		$issue_card_id=$row['issue_card_id'];
		$nestedData[]=$row['issue_card_date'];
		$nestedData[]=$row['issue_card_ref_no'];
		$nestedData[]=$row['user_first_name'];
		$nestedData[]=$row['total_amount'];
		$nestedData[]='<div class="btn-group text-left">
                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            <li><a href="'.base_url().'issue_cards/issue_card_details/'.$issue_card_id.'"><i class="fa fa-file-text-o"></i> Issue Card Details</a></li>
							
							
							
                            </ul></div>';
	
		$data[]=$nestedData;
	}	
	
	
	$json_data = array(
	"data"=>$data
	);
	
	echo json_encode($json_data);
	
		
	}
	
	
	
	
}