<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manual_Function_Model extends CI_Model {
  
  private $tableName = '';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }

	function save_area($area_data,$area_id)
	{
		if (!$area_id)
		{
			//$this->db->insert($this->tableName,$area_data);
		}else {
			//$this->db->where('area_id', $area_id);
			//return $this->db->update($this->tableName,$area_data);
		}
	}	
	
	public function disable_product($id)
	{
		$data = array(
			'product_status' => 0
		);	
		$this->db->where('product_id', $id);
		$this->db->update('product', $data);
	}
	
	public function enable_product($id)
	{
		$data = array(
			'product_status' => 1
		);	
		$this->db->where('product_id', $id);
		$this->db->update('product', $data);
	}
	
	public function get_unpaid_sales()
	{		
		$this->db->select('s.*');
		$this->db->from('sales s');
		$this->db->where("s.payment_status", 0);
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	public function close_sale($id)
	{
		if($id>0){
			$data = array(
			'payment_status' => 1,
			'closed_date' => date("Y-m-d H:i:s")
		);	
		$this->db->where('sale_id', $id);
		$this->db->update('sales', $data);
		}else{
			return false;
		}
		
	}

	public function get_uncomplte_multiple_payment()
	{		
		$this->db->select('s.*');
		$this->db->from('sale_multiple_payment s');
		$this->db->where("s.payment_settlement_status", 0);
		$query = $this->db->get();
		return $query->result_array(); 	
	}

	function get_total_sale_paid_by_smp_id($id)
    {
        $this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
        $this->db->where('sp.smp_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();

        if($result['sale_pymnt_amount']){
            return $result['sale_pymnt_amount'];
        }else{
            return 0;
        }
	}
	
	function get_total_cheque_return_paid_by_smp_id($id)
    {
        $this->db->select_sum('sp.paid_amount');
        $this->db->from('cheque_return_payment sp');
        $this->db->where('sp.smp_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();
        if($result['paid_amount']){
            return $result['paid_amount'];
        }else{
            return 0;
        }
	}
	
	public function close_payment($id)
	{
		if($id>0){
			$data = array(
			'payment_settlement_status' => 1
		);	
		$this->db->where('smp_id', $id);
		$this->db->update('sale_multiple_payment', $data);
		}else{
			return false;
		}		
	}


	public function get_pending_sale_list()
	{	
		$this->db->select('s.*');
		$this->db->from('sales s');
		$this->db->join('customer c','c.cus_id=s.customer_id','left');
		$this->db->where("s.payment_status", 0);https://github.com/ajaxorg/ace/wiki/Default-Keyboard-Shortcuts
		$this->db->where("c.cus_credit_status", 1);
		$this->db->order_by('s.sale_datetime','desc');
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
		public function get_not_updated_initial_batch()
	{		
		$this->db->select('p.*');
		$this->db->from('product p');
		$this->db->where("p.added_initial_batch", 0);
		$this->db->limit(1000);
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
		function save_batch($data)
	{
		if ($data)
		{
			$this->db->insert('batch_product',$data);
		}
	}
	
		public function update_product($id)
	{
	    if($id>0){
	        	$data = array(
			'added_initial_batch' => 1
		);	
		$this->db->where('product_id', $id);
		$this->db->update('product', $data);
	        
	    }else{
	        echo "Update Error";
	        return false;
	    }
	}
	
	function insert_initial_grn($data)
	{
		if ($data)
		{
			$this->db->insert('purchase_items',$data);
			$id = $this->db->insert_id();
			return $id;
		}else{
		    return false;
		}
	}
	
	public function delete_grn_1()
	{
		//$this->db->where('purchase_id', 1);
	//	$this->db->delete('purchase_items');
	}
	
	
	function duplicate_m($id='')
    {
        $q;
        
        $this->db->select('count(*) as cnt');
        $this->db->select('sale_reference_no,unique_no');
        if($id){
        $this->db->where('float_id', $id);
        }
        $this->db->group_by(array("unique_no"));
        $this->db->having("cnt > 1", null, false);
        $this->db->limit(10000000);
        $q= $this->db->get("hw_sales");
        return $q->result();

    }
    
    function get_grn_item(){
        $this->db->select('s.*');
		$this->db->from('purchase_items s');
		$this->db->where("s.update_done", 0);
		$this->db->limit(5000);
		$query = $this->db->get();
		return $query->result_array(); 
    }
    public function update_batch_grn($id,$data)
	{
	    if($id>0){
		$this->db->where('grn_item_id', $id);
		$this->db->update('btatch_prroduct_grn', $data);
	    }else{
	        return false;
	    }
	}
	public function update_purchese_items($id,$data)
	{
	    if($id>0){
		$this->db->where('id', $id);
		$this->db->update('purchase_items', $data);
	    }else{
	        return false;
	    }
	}
	
	 function get_sale_uniq_null_record(){
        $this->db->select('s.sale_id');
		$this->db->from('hw_sales s');
		$this->db->where("s.unique_no", null);
		$this->db->limit(50000);
		$query = $this->db->get();
		return $query->result_array(); 
    }
    
    	public function update_sale_master($id,$data)
	{
	    if($id>0){
		$this->db->where('sale_id', $id);
		$this->db->update('hw_sales', $data);
	    }else{
	        return false;
	    }
	}
	
	function get_stock_ledger_not_update_batch(){
        $this->db->select('s.batch_id,s.product_id');
		$this->db->from('batch_product s');
		$this->db->where("s.batch_status", 1);
		$this->db->where("s.st_ldg_update", 0);
		$this->db->limit(1000);
		$query = $this->db->get();
		return $query->result_array(); 
    }
	
		function save_stock_lodge($data)
	{
		if ($data)
		{
			return $this->db->insert('stock_ledger',$data);
			//$id = $this->db->insert_id();
		//	return $id;
		}else{
		    return false;
		}
	}
	
	public function update_batch_master($id,$data)
	{
	    if($id>0){
		$this->db->where('batch_id', $id);
		$this->db->update('batch_product', $data);
	    }else{
	        return false;
	    }
	}
	
	
	
	
}