<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Vehicle extends CI_Controller {

    var $main_menu_name = "settings";
	var $sub_menu_name = "vehicle";
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('Vehicle_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		
	}

	public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('vehicle',$data);
	}
	
	
	public function get_all_vehicle_by_warehouse_id()
	{
	
		$warehouse_id=$this->input->get('WH');
		$vehicle = $this->Vehicle_Model->get_all_vehicle_by_warehouse_id($warehouse_id);
		echo json_encode($vehicle);
		
		
	
		
	}
	
	
	public function save_vehicle()
	{
		$vehicle_id=$this->input->post('vehicle_id');
		$type=$this->input->post('type');
		$vehicle_name=$this->input->post('vehicle_name');
		$vehicle_code=$this->input->post('vehicle_code');
		$warehouse_id=$this->input->post('warehouse_id');
		$driver_id=$this->input->post('driver_id');
		$data=array(
			'vehicle_name'=>$vehicle_name,
			'vehicle_code'=>$vehicle_code,
			'warehouse_id'=>$warehouse_id,
			'driver_id' => $driver_id
		);
		
		$this->load->library('form_validation'); //form validation lib
		if($type=='A')
		{
			$this->form_validation->set_rules('vehicle_code', 'Code', 'required|is_unique[vehicles.vehicle_code]');
			$this->form_validation->set_rules('driver_id', 'Driver', 'required');
		}
		else if($type=='E')
		{
			$this->form_validation->set_rules('vehicle_code', 'Code', 'required');
			$this->form_validation->set_rules('driver_id', 'Driver', 'required');
		}
		
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
		
		$_insert=$this->Vehicle_Model->save_vehicle($data,$vehicle_id);
		$lastid=$this->db->insert_id();

		if($type=='A'){
			if ($lastid) {
				echo json_encode(array('id'=>$lastid,'type'=>$type));
			} else {
				echo json_encode(array('status'=>'error'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type));
		}
		}
	}

	public function add_vehicle()
	{
	    $this->load->model('Drivers_Model');
        if (isset($_GET['vehicle_id'])) {
			$vehicle_id=$_GET['vehicle_id'];
		}
		else {
			$vehicle_id='';
		}
		if($vehicle_id){
			$data['vehicle_id']=$vehicle_id;
			$data['type']='E';
			$data['pageName']='UPDATE  vehicle';
			$data['btnText']='Update vehicle';
			$data['vehicles_details']= $this->Vehicle_Model->get_vehicle_info($vehicle_id);	
			$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		}
		else {
			$data['vehicle_id']='';
			$data['type']='A';
			$data['pageName']='ADD vehicle';
			$data['btnText']='Add vehicle';
			$data['vehicles_details']=array();
			$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		}
		$data['driver_list'] = $this->Drivers_Model->get_all_drivers();
		//echo "<pre>";
		//print_r($data['driver_list']);
        $this->load->view('models/create_vehicle',$data);
	}

	public function list_vehicle()
	{
	$requestData= $_REQUEST;
	
	$columns = array( 
		0 =>'vehicle_code', 
		1 => 'vehicle_name'
	);
	
	$data = array();
	$vehicle = $this->Vehicle_Model->get_all_vehicle();
	$totalData = count($vehicle);
	$totalFiltered = $totalData;  
	
	foreach ($vehicle as $row){
		$nestedData=array(); 
		$nestedData[] =$row['vehicle_code'];
		$nestedData[] = $row['vehicle_name'];
		$nestedData[] = $row['name'];
		$actionTxtDisble='';
		$actionTxtEnable='';
		$actionTxtUpdate='';
		$actionTxtDelete='';
		$actionTxtUpdate='<a onClick="click_vehicle_update_btn('.$row['vehicle_id'].')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="glyphicon fa fa-edit"></i></a> &nbsp;';
		if($row['vehicle_status']==1){
			$actionTxtDisble = '<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable supplier" onClick="disableUnitData('.$row['vehicle_id'].')"><i class="glyphicon fa fa-check"></i></a> &nbsp;';
	}
		if($row['vehicle_status']==0){
			$actionTxtEnable = '<a class="btn btn-xs btn-warning tooltips" data-placement="top" data-original-title="Disable supplier" onClick="enableUnitData('.$row['vehicle_id'].')"><i class="glyphicon fa fa-minus-circle"></i></a> &nbsp;';
	}
		$actionTxtDelete='<a class="btn btn-xs btn-bricky tooltips" data-placement="top" data-original-title="Delete supplier" onClick="deleteUnitData('.$row['vehicle_id'].')">
															<i class="glyphicon fa fa-trash-o"></i></a>';
	
	$nestedData[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtDelete;
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}


	function delete_vehicle() {
		$vehicle_id	= $this->input->post('vehicle_id');
		$this->Vehicle_Model->delete_vehicle($vehicle_id);
        if ($vehicle_id) {
        	echo json_encode(array('id'=>$vehicle_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function disable_vehicle() {
		$vehicle_id	= $this->input->post('vehicle_id');
		$this->Vehicle_Model->disable_vehicle($vehicle_id);
        if ($vehicle_id) {
        	echo json_encode(array('id'=>$vehicle_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function enable_vehicle() {
		$vehicle_id	= $this->input->post('vehicle_id');
		$this->Vehicle_Model->enable_vehicle($vehicle_id);
        if ($vehicle_id) {
        	echo json_encode(array('id'=>$vehicle_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
}