<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Marketing_Loading_Process extends CI_Controller {

    var $main_menu_name = "marketing_loading_process";
	var $sub_menu_name = "marketing_loading_process";

	public function __construct()
	{
		parent::__construct();
        date_default_timezone_set("Asia/Colombo");
		$this->load->model('Marketing_Delivery_Model');
		$this->load->model('Supplier_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		$this->load->model('User_Model');
		
		
	}
	
	
	//Sales list page load
	public function index()
	{	
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "delivery_list";
        $this->load->view('delivery/delivery_list',$data);
	}
	
	
	
	public function get_all_approved_issue_delivary()
	{
		$list=$this->Marketing_Delivery_Model->get_delivary_pending();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{
			$sub_action='<li><a href="'.base_url().'marketing_delivery_process/loading_details/'.$row['id'].'"><i class="fa fa-file-text-o"></i> Delivary Details</a></li>
			
			<li><a href="'.base_url().'marketing_loading_process/picking_item_list/'.$row['id'].'"><i class="fa fa-file-text-o"></i> Pick Items</a></li>
			
			
			';
			if($row['approval_status']=="APPROVED"){
			$loaded_to_lorry='<li><a href="#" onClick="finish_loading('.$row['id'].')"><i class="fa fa-file-text-o"></i> Loaded to lorry</a></li>';}
			else
			{
				$loaded_to_lorry='';
			}
			$action='<div class="btn-group text-left">                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$sub_action.''.$loaded_to_lorry.' </ul></div>';
			$nested_data= array();
			
			$date=date_create($row['loading_date_time']);
	       
			$nested_data[]=date_format($date,"Y-m-d"); 
			$nested_data[]=$row['loading_ref_no'];
			
			$nested_data[]=$row['area_name'];
			$nested_data[]=$row['user_first_name'];
			$nested_data[]=$row['vehicle_code'];
			$nested_data[]=$row['status'] ;
			$nested_data[]=$row['approval_status'] ;
			$nested_data[]=$action ;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}	
	
	
	
	public function picking_item_list()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "pick_list";
		$loading_id =$this->uri->segment('3');
		$delivary_details=$this->Marketing_Delivery_Model->get_delivary_details($loading_id);				
		$data['delivary_details']=$delivary_details; 
        $this->load->view('delivery/sample_pick_list',$data);
	}
	
	
	
}